package net.w_horse.excelpojo.xml.tag;

public enum RetrieveFrom {
	NONE("none"), LEFT("left"), RIGHT("right"), BOTTOM("bottom");

	private String value;
	private RetrieveFrom(String value) {
		this.value = value;
	}
	public String getValue() {
		return this.value;
	}

	public static String getTagName() {
		return "retrieveFrom";
	}

	public static boolean equalas(RetrieveFrom elementName, String expr) {
		RetrieveFrom retrieveTypeExpr = getElement(expr);
		return (retrieveTypeExpr == elementName);
	}

	public static boolean equalsIgnoreCase(RetrieveFrom elementName, String expr) {
		RetrieveFrom retrieveTypeExpr = getElementIgnoreCase(expr);
		return (retrieveTypeExpr == elementName);
	}

	public boolean equals(String expr) {
		return getValue().equals(expr);
	}
	public boolean equalsIgnoreCase(String expr) {
		return getValue().equalsIgnoreCase(expr);
	}

	private static RetrieveFrom getElement(String elementName) {
		for (RetrieveFrom retrieveType : values()) {
			if (retrieveType.equals(elementName)) {
				return retrieveType;
			}
		}
		return NONE;
	}
	private static RetrieveFrom getElementIgnoreCase(String elementName) {
		for (RetrieveFrom retrieveType : values()) {
			if (retrieveType.equalsIgnoreCase(elementName)) {
				return retrieveType;
			}
		}
		return NONE;
	}
}
